<?php

function bt_tag_cloud_filter($args = array()) {
    $args['smallest'] = 0.8;
    $args['largest'] = 0.8;
    $args['unit'] = 'em';
    return $args;
}

add_filter('widget_tag_cloud_args', 'bt_tag_cloud_filter', 90);

/**
 * Default header dash
 */
if ( ! function_exists( 'boldthemes_header_headline_size' ) ) {
	function boldthemes_header_headline_size() {
		return "large"; // 
	}
}
add_filter( 'boldthemes_header_headline_size', 'boldthemes_header_headline_size' );


/**
 * Product headline size
 */
/*if ( ! function_exists( 'boldthemes_product_headline_size' ) ) {
	function boldthemes_product_headline_size( $size ) {
		return 'extralarge';
	}
}
add_filter( 'boldthemes_product_headline_size', 'boldthemes_product_headline_size' );
*/

/* Custom header style */

if ( ! function_exists( 'boldthemes_customize_header_style' ) ) {
	function boldthemes_customize_header_style( $wp_customize ) {
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[header_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['header_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'header_style', array(
			'label'     => esc_html__( 'Header Style', 'oxigeno' ),
			'description'    => esc_html__( 'Select header style for all the pages on the site.', 'oxigeno' ),
			'section'   => BoldThemesFramework::$pfx . '_header_footer_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[header_style]',
			'priority'  => 62,
			'type'      => 'select',
			'choices'   => array(
				'transparent-light'  	=> esc_html__( 'Transparent Light', 'oxigeno' ),
				'transparent-dark'   	=> esc_html__( 'Transparent Dark', 'oxigeno' ),
				'accent-dark' 			=> esc_html__( 'Accent + Dark', 'oxigeno' ),
				'accent-light' 			=> esc_html__( 'Accent + Light', 'oxigeno' ),
				'alternate-light' 		=> esc_html__( 'Alternate + Light', 'oxigeno' ),
				'alternate-dark' 		=> esc_html__( 'Alternate + Dark', 'oxigeno' ),
				'light-accent' 			=> esc_html__( 'Light + Accent ', 'oxigeno' ),
				'light-dark' 			=> esc_html__( 'Light + Dark', 'oxigeno' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_header_style' );