<?php

BoldThemes_Customize_Default::$data['body_font'] = 'Montserrat';
BoldThemes_Customize_Default::$data['heading_supertitle_font'] = 'Montserrat';
BoldThemes_Customize_Default::$data['heading_font'] = 'Montserrat';
BoldThemes_Customize_Default::$data['heading_subtitle_font'] = 'Libre Baskerville';
BoldThemes_Customize_Default::$data['menu_font'] = 'Montserrat';
BoldThemes_Customize_Default::$data['buttons_shape'] = 'soft-rounded';

BoldThemes_Customize_Default::$data['accent_color'] = '#3da3e6';
BoldThemes_Customize_Default::$data['alternate_color'] = '#00ffff';
BoldThemes_Customize_Default::$data['logo_height'] = '80';
BoldThemes_Customize_Default::$data['crest_width'] = '100';
BoldThemes_Customize_Default::$data['header_style'] = 'light-dark';
BoldThemes_Customize_Default::$data['header_headline_style'] = 'light_alternate';

BoldThemes_Customize_Default::$data['template_skin'] = 'light';
BoldThemes_Customize_Default::$data['crest'] = '';

BoldThemes_Customize_Default::$data['blog_list_view'] = 'standard';
BoldThemes_Customize_Default::$data['pf_list_view'] = 'columns';
BoldThemes_Customize_Default::$data['pf_single_view'] = 'columns';


/* NEW CUSTOMIZE PARAM */
if ( ! function_exists( 'boldthemes_customize_crest' ) ) {
	function boldthemes_customize_crest( $wp_customize ) {
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[crest]', array(
			'default'           => BoldThemes_Customize_Default::$data['crest'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_image'
		));
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'crest', array(
			'label'    => esc_html__( 'Crest', 'oxigeno' ),
			'description'    => esc_html__( 'Main website crest, displayed in the header area, next to main logo. Crest size should match height defined in Header and Footer > Crest Height (in px).', 'oxigeno' ),
			'section'  => BoldThemesFramework::$pfx . '_general_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[crest]',
			'priority' => 0,
			'context'  => BoldThemesFramework::$pfx . '_crest'
		)));		
	}
}
add_action( 'customize_register', 'boldthemes_customize_crest' );


// CREST WIDTH
if ( ! function_exists( 'boldthemes_customize_crest_width' ) ) {
	function boldthemes_customize_crest_width( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[crest_width]', array(
			'default'           => BoldThemes_Customize_Default::$data['crest_width'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field'
		));

		$wp_customize->add_control( 'crest_width', array(
			'label'    => esc_html__( 'Crest Width (in px)', 'oxigeno' ),
			'description'    => esc_html__( 'Define the crest height by setting it’s size in pixels (without px unit).', 'oxigeno' ),
			'section'  => BoldThemesFramework::$pfx . '_header_footer_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[crest_width]',
			'priority' => 50,
			'type'     => 'text'
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_crest_width' );


// HEADER HEADLINE STYLE
if ( ! function_exists( 'boldthemes_customize_header_headline_style' ) ) {
	function boldthemes_customize_header_headline_style( $wp_customize ) {

		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[header_headline_style]', array(
			'default'			=> BoldThemes_Customize_Default::$data['header_headline_style'],
			'type'				=> 'option',
			'capability'		=> 'edit_theme_options',
			'sanitize_callback'	=> 'boldthemes_sanitize_select'
		));

		$wp_customize->add_control( 'header_headline_style', array(
			'label'		=> esc_html__( 'Header Headline Style', 'oxigeno' ),
			'description'    => esc_html__( 'Select header style for all the pages on the site.', 'oxigeno' ),
			'section'  	=> BoldThemesFramework::$pfx . '_general_section',
			'settings'	=> BoldThemesFramework::$pfx . '_theme_options[header_headline_style]',
			'priority'	=> 42,
			'type'		=> 'select',
			'choices'	=> array(
				'light_accent'		=> esc_html__( 'Light + Accent', 'oxigeno' ),
				'dark_accent'		=> esc_html__( 'Dark + Accent', 'oxigeno' ),
				'light_alternate'	=> esc_html__( 'Light + Alternate', 'oxigeno' ),
				'dark_alternate'	=> esc_html__( 'Dark + Alternate', 'oxigeno' ),
				'light'				=> esc_html__( 'Light', 'oxigeno' ),
				'dark'				=> esc_html__( 'Dark', 'oxigeno' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_header_headline_style' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_header_headline_style' );


// NEW PARAM: IMAGE SLIDER
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_slider', array(
		array( 'param_name' => 'show_arrows',
			'type' => 'dropdown',
			'heading' => esc_html__( 'Show Arrows', 'oxigeno' ),
			'preview' => true,
			'value' => array(
				esc_html__( 'Show', 'oxigeno' ) => 'show',
				esc_html__( 'Hide', 'oxigeno' ) => 'hide_arrows'
			)
		)
	) );
}

function oxygen_club_bt_bb_slider_class( $class, $atts ) {
	if ( isset( $atts['show_arrows'] ) && $atts['show_arrows'] != '' ) {
		$class[] = 'bt_bb_show_arrows' . '_' . $atts['show_arrows'];
	}
	return $class;
}
add_filter( 'bt_bb_slider_class', 'oxygen_club_bt_bb_slider_class', 10, 2 );



/* NEW ELEMENT PARAMS  */
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( "bt_bb_section", 'layout' );
	bt_bb_remove_params( "bt_bb_section", 'background_overlay' );
	bt_bb_remove_params( "bt_bb_icon", 'style' );
	bt_bb_remove_params( "bt_bb_service", 'style' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {

	bt_bb_add_params( 'bt_bb_icon', array(
		array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Style', 'oxigeno' ), 'preview' => true, 'group' => esc_html__( 'Design', 'oxigeno' ),
			'value' => array(
				esc_html__( 'Outline', 'oxigeno' ) 				=> 'outline',
				esc_html__( 'Filled', 'oxigeno' ) 				=> 'filled',
				esc_html__( 'Filled with border', 'oxigeno' ) 	=> 'filled-border',
				esc_html__( 'Borderless', 'oxigeno' ) 			=> 'borderless'
			)
		)
	) );
	
	bt_bb_add_params( 'bt_bb_service', array(
		array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Style', 'oxigeno' ), 'preview' => true, 'group' => esc_html__( 'Design', 'oxigeno' ),
			'value' => array(
				esc_html__( 'Outline', 'oxigeno' ) 				=> 'outline',
				esc_html__( 'Filled', 'oxigeno' ) 				=> 'filled',
				esc_html__( 'Filled with border', 'oxigeno' ) 	=> 'filled-border',
				esc_html__( 'Borderless', 'oxigeno' ) 			=> 'borderless'
			)
		)
	) );
	
	bt_bb_add_params( 'bt_bb_column', array(
		array( 'param_name' => 'highlight', 'type' => 'dropdown', 'heading' => esc_html__( 'Highlight', 'oxigeno' ), 'preview' => true, 'group' => esc_html__( 'Design', 'oxigeno' ),
			'value' => array(
				esc_html__( 'No', 'oxigeno' ) 		=> 'no-highlight',
				esc_html__( 'Shadow', 'oxigeno' ) 	=> 'shadow'
			)
		)
	) );
			
	bt_bb_add_params( 'bt_bb_section', array(
		array( 'param_name' => 'layout', 'type' => 'dropdown', 'default' => 'boxed_1200', 'heading' => esc_html__( 'Layout', 'oxigeno' ), 'group' => esc_html__( 'General', 'oxigeno' ), 'weight' => 0, 'preview' => true,
			'value' => array(
				esc_html__( 'Boxed (1200px)', 'oxigeno' ) 				=> 'boxed_1200',
				esc_html__( 'Boxed right (1200px)', 'oxigeno' ) 		=> 'boxed_right_1200',
				esc_html__( 'Boxed left (1200px)', 'oxigeno' ) 			=> 'boxed_left_1200',
				esc_html__( 'Boxed left & right (1200px)', 'oxigeno' ) 	=> 'boxed_left_right_1200',
				esc_html__( 'Wide', 'oxigeno' ) 						=> 'wide',
				esc_html__( 'Boxed (800px)', 'oxigeno' ) 				=> 'boxed_800',
				esc_html__( 'Boxed (900px)', 'oxigeno' ) 				=> 'boxed_900',
				esc_html__( 'Boxed (1000px)', 'oxigeno' ) 				=> 'boxed_1000',
				esc_html__( 'Boxed (1100px)', 'oxigeno' ) 				=> 'boxed_1100',
				esc_html__( 'Boxed (1300px)', 'oxigeno' ) 				=> 'boxed_1300',
				esc_html__( 'Boxed (1400px)', 'oxigeno' ) 				=> 'boxed_1400',
				esc_html__( 'Boxed (1500px)', 'oxigeno' ) 				=> 'boxed_1500',
				esc_html__( 'Boxed (1600px)', 'oxigeno' ) 				=> 'boxed_1600'
			)
		),

		array( 'param_name' => 'background_overlay', 'type' => 'dropdown', 'heading' => esc_html__( 'Background overlay', 'oxigeno' ), 'group' => esc_html__( 'Design', 'oxigeno' ), 'weight' => 4, 
			'value' => array(
				esc_html__( 'No overlay', 'oxigeno' )    		=> '',
				esc_html__( 'Light stripes', 'oxigeno' ) 		=> 'light_stripes',
				esc_html__( 'Dark stripes', 'oxigeno' )  		=> 'dark_stripes',
				esc_html__( 'Light solid', 'oxigeno' )	  		=> 'light_solid',
				esc_html__( 'Dark solid', 'oxigeno' )	  		=> 'dark_solid',
				esc_html__( 'Light gradient', 'oxigeno' )	  	=> 'light_gradient',
				esc_html__( 'Dark gradient', 'oxigeno' )	  	=> 'dark_gradient',
				esc_html__( 'Accent gradient', 'oxigeno' )	  	=> 'accent_gradient',
				esc_html__( 'Alternate gradient', 'oxigeno' )	  => 'alternate_gradient'
			)
		),

		array( 'param_name' => 'top_negative_margin', 'type' => 'dropdown', 'heading' => esc_html__( 'Top negative margin', 'oxigeno' ), 'preview' => true,
			'value' => array(
				esc_html__( 'No margin', 'oxigeno' ) 	=> '',
				esc_html__( 'Extra small', 'oxigeno' ) 	=> 'extra_small',
				esc_html__( 'Small', 'oxigeno' ) 		=> 'small',		
				esc_html__( 'Normal', 'oxigeno' )	 	=> 'normal',
				esc_html__( 'Medium', 'oxigeno' ) 		=> 'medium',
				esc_html__( 'Large', 'oxigeno' ) 		=> 'large',
				esc_html__( 'Extra large', 'oxigeno' ) 	=> 'extra_large'
			)
		),

		array( 'param_name' => 'bottom_negative_margin', 'type' => 'dropdown', 'heading' => esc_html__( 'Bottom negative margin', 'oxigeno' ), 'preview' => true,
			'value' => array(
				esc_html__( 'No margin', 'oxigeno' ) 	=> '',
				esc_html__( 'Extra small', 'oxigeno' ) 	=> 'extra_small',
				esc_html__( 'Small', 'oxigeno' ) 		=> 'small',		
				esc_html__( 'Normal', 'oxigeno' ) 		=> 'normal',
				esc_html__( 'Medium', 'oxigeno' ) 		=> 'medium',
				esc_html__( 'Large', 'oxigeno' ) 		=> 'large',
				esc_html__( 'Extra large', 'oxigeno' ) 	=> 'extra_large'
			)
		),
		
		array( 'param_name' => 'highlight', 'type' => 'dropdown', 'heading' => esc_html__( 'Highlight', 'oxigeno' ), 'preview' => true, 'group' => esc_html__( 'Design', 'oxigeno' ),
			'value' => array(
				esc_html__( 'No', 'oxigeno' ) 		=> 'no-highlight',
				esc_html__( 'Shadow', 'oxigeno' ) 	=> 'shadow'
			)
		)
	) );
}

function oxygen_club_bt_bb_section_class( $class, $atts ) {
	if ( isset( $atts['top_negative_margin'] ) && $atts['top_negative_margin'] != '' ) {
		$class[] = 'bt_bb_top_negative_margin' . '_' . $atts['top_negative_margin'];
	}
	
	if ( isset( $atts['bottom_negative_margin'] ) && $atts['bottom_negative_margin'] != '' ) {
		$class[] = 'bt_bb_bottom_negative_margin' . '_' . $atts['bottom_negative_margin'];
	}
	
	if ( isset( $atts['highlight'] ) && $atts['highlight'] != 'no-highlight' && $atts['highlight'] != ''  ) {
		$class[] = 'bt_bb_highlight_' . $atts['highlight'];
	}

	return $class;
}
add_filter( 'bt_bb_section_class', 'oxygen_club_bt_bb_section_class', 10, 2 );

function oxygen_club_bt_bb_column_class( $class, $atts ) {
	if ( isset( $atts['highlight'] ) && $atts['highlight'] != 'no-highlight' && $atts['highlight'] != ''  ) {
		$class[] = 'bt_bb_highlight_' . $atts['highlight'];
	}
	return $class;
}
add_filter( 'bt_bb_column_class', 'oxygen_club_bt_bb_column_class', 10, 2 );


function oxygen_club_bt_bb_icon_class( $class, $atts ) {
	if ( isset( $atts['style'] ) && $atts['style'] == 'filled-border' ) {
		$class[] = 'bt_bb_style_filled';
		$class[] = 'bt_bb_style_border';
	}
	return $class;
}
add_filter( 'bt_bb_icon_class', 'oxygen_club_bt_bb_icon_class', 10, 2 );


function oxygen_club_bt_bb_service_class( $class, $atts ) {
	if ( isset( $atts['style'] ) && $atts['style'] == 'filled-border' ) {
		$class[] = 'bt_bb_style_filled';
		$class[] = 'bt_bb_style_border';
	}
	return $class;
}
add_filter( 'bt_bb_service_class', 'oxygen_club_bt_bb_service_class', 10, 2 );


/* FRONT END 
---------------------------------------------------------- */

/* OLD ELEMENTS */
function bt_bb_fe_new_params( $elements_array) {
	
	$elements_array[ 'bt_bb_section' ][ 'params' ][ 'top_negative_margin' ] = array( 'ajax_filter' => array( 'class' ) );
	$elements_array[ 'bt_bb_section' ][ 'params' ][ 'bottom_negative_margin' ] = array( 'ajax_filter' => array( 'class' ) );
	$elements_array[ 'bt_bb_section' ][ 'params' ][ 'highlight' ] = array( 'ajax_filter' => array( 'class' ) );

	$elements_array[ 'bt_bb_counter' ][ 'params' ][ 'icon' ] = array();


    return $elements_array;
}
add_filter( 'bt_bb_fe_elements', 'bt_bb_fe_new_params' );



/* FRONT EDITOR - NEW ELEMENTS */
function oxygen_bt_bb_fe( $elements ) {

	$elements[ 'bt_bb_game_result' ] = array(
		'edit_box_selector' => '',
		'params' => array( 
			'supertitle'     		=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_game_result_supertitle', 'type' => 'inner_html' ) ),
			'image_1'        		=> array(),
			'title_1'        		=> array(),
			'subtitle_1'     		=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_game_result_team_left .bt_bb_game_result_title', 'type' => 'inner_html' ) ),		
			'title_2'        		=> array(),
			'subtitle_2'     		=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_game_result_team_right .bt_bb_game_result_title', 'type' => 'inner_html' ) ),
			'image_2'        		=> array(),
			'button_text'     		=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_game_result_button .bt_bb_button_text', 'type' => 'inner_html' ) ),
			'url'					=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'href' ) ),
			'target' 				=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'target' ) ),
		),
	);
	$elements[ 'bt_bb_scheduled_game' ] = array(
		'edit_box_selector' => '',
		'params' => array( 
			'image'        		=> array(),
			'title'        		=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_scheduled_game_title', 'type' => 'inner_html' ) ),
			'supertitle'     	=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_scheduled_game_supertitle', 'type' => 'inner_html' ) ),
			'subtitle'     		=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_scheduled_game_subtitle', 'type' => 'inner_html' ) ),
			'url'				=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'href' ) ),
			'target' 			=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'target' ) ),
			'color_scheme'  	=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_icon', 'type' => 'class' ) ),
		),
	);
	$elements[ 'bt_bb_table' ] = array(
		'edit_box_selector' => '',
		'params' => array( 
			'content'			=> array(),
		),
	);
	$elements[ 'bt_bb_timetable' ] = array(
		'edit_box_selector' => '',
		'params' => array( 
			'title'				=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_timetable_title', 'type' => 'inner_html' ) ),
			'location'			=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_timetable_location', 'type' => 'inner_html' ) ),
			'content'			=> array(),
		),
	);


	return $elements;
}
add_filter( 'bt_bb_fe_elements', 'oxygen_bt_bb_fe' );
