<?php
if ( class_exists( 'BoldThemesFramework' ) && isset( BoldThemesFramework::$crush_vars ) ) {
	$boldthemes_crush_vars = apply_filters( 'boldthemes_crush_vars', BoldThemesFramework::$crush_vars );
}
if ( class_exists( 'BoldThemesFramework' ) && isset( BoldThemesFramework::$crush_vars_def ) ) {
	$boldthemes_crush_vars_def = BoldThemesFramework::$crush_vars_def;
}
if ( isset( $boldthemes_crush_vars['accentColor'] ) ) {
	$accentColor = $boldthemes_crush_vars['accentColor'];
} else {
	$accentColor = "#3da3e6";
}
if ( isset( $boldthemes_crush_vars['alternateColor'] ) ) {
	$alternateColor = $boldthemes_crush_vars['alternateColor'];
} else {
	$alternateColor = "#00ffff";
}
if ( isset( $boldthemes_crush_vars['bodyFont'] ) ) {
	$bodyFont = $boldthemes_crush_vars['bodyFont'];
} else {
	$bodyFont = "Montserrat";
}
if ( isset( $boldthemes_crush_vars['menuFont'] ) ) {
	$menuFont = $boldthemes_crush_vars['menuFont'];
} else {
	$menuFont = "Montserrat";
}
if ( isset( $boldthemes_crush_vars['headingFont'] ) ) {
	$headingFont = $boldthemes_crush_vars['headingFont'];
} else {
	$headingFont = "Montserrat";
}
if ( isset( $boldthemes_crush_vars['headingSuperTitleFont'] ) ) {
	$headingSuperTitleFont = $boldthemes_crush_vars['headingSuperTitleFont'];
} else {
	$headingSuperTitleFont = "Montserrat";
}
if ( isset( $boldthemes_crush_vars['headingSubTitleFont'] ) ) {
	$headingSubTitleFont = $boldthemes_crush_vars['headingSubTitleFont'];
} else {
	$headingSubTitleFont = "Libre Baskerville";
}
if ( isset( $boldthemes_crush_vars['logoHeight'] ) ) {
	$logoHeight = $boldthemes_crush_vars['logoHeight'];
} else {
	$logoHeight = "80";
}
if ( isset( $boldthemes_crush_vars['crestWidth'] ) ) {
	$crestWidth = $boldthemes_crush_vars['crestWidth'];
} else {
	$crestWidth = "100";
}
$accentColorDark = CssCrush\fn__l_adjust( $accentColor." -10" );$accentColorVeryDark = CssCrush\fn__l_adjust( $accentColor." -20" );$accentColorVeryVeryDark = CssCrush\fn__l_adjust( $accentColor." -30" );$accentColorLight = CssCrush\fn__l_adjust( $accentColor." 10" );$accentColorTransparent = CssCrush\fn__a_adjust( $accentColor." -100" );$alternateColorDark = CssCrush\fn__l_adjust( $alternateColor." -10" );$alternateColorVeryDark = CssCrush\fn__l_adjust( $alternateColor." -20" );$alternateColorVeryVeryDark = CssCrush\fn__l_adjust( $alternateColor." -35" );$alternateColorLight = CssCrush\fn__l_adjust( $alternateColor." 10" );$alternateColorTransparent = CssCrush\fn__a_adjust( $alternateColor." -100" );$css_override = sanitize_text_field("select,
input{font-family: \"{$bodyFont}\",Arial,Helvetica,sans-serif;}
input:not([type='checkbox']):not([type='radio']):not([type='submit']):focus,
textarea:focus,
.fancy-select .trigger.open{-webkit-box-shadow: 0 0 4px 0 {$accentColor};
    box-shadow: 0 0 4px 0 {$accentColor};}
a:hover{
    color: {$accentColor};}
.btContent a:hover{color: {$accentColor};}
.btText a{color: {$accentColor};}
body{font-family: \"{$bodyFont}\",Arial,Helvetica,sans-serif;}
h1,
h2,
h3,
h4,
h5,
h6,
h7,
h8{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
blockquote{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.btContentHolder table thead th{
    background-color: {$accentColor};}
.btAccentDarkHeader .btPreloader .animation > div:first-child,
.btLightAccentHeader .btPreloader .animation > div:first-child,
.btTransparentLightHeader .btPreloader .animation > div:first-child{
    background-color: {$accentColor};}
.btPreloader .animation .preloaderLogo{height: {$logoHeight}px;}
.bt_bb_background_image.btPageHeadline header h1 .bt_bb_headline_content,
.bt_bb_background_image.btPageHeadline header h2 .bt_bb_headline_content,
.bt_bb_background_image.btPageHeadline header h3 .bt_bb_headline_content,
.bt_bb_background_image.btPageHeadline header h4 .bt_bb_headline_content,
.bt_bb_background_image.btPageHeadline header h5 .bt_bb_headline_content,
.bt_bb_background_image.btPageHeadline header h6 .bt_bb_headline_content,
.bt_bb_background_image.btPageHeadline header h7 .bt_bb_headline_content,
.bt_bb_background_image.btPageHeadline header h8 .bt_bb_headline_content{color: {$alternateColor};}
.bt_header_headline_Light_accent .bt_bb_background_image.btPageHeadline header h1 .bt_bb_headline_content,
.bt_header_headline_Light_accent .bt_bb_background_image.btPageHeadline header h2 .bt_bb_headline_content,
.bt_header_headline_Light_accent .bt_bb_background_image.btPageHeadline header h3 .bt_bb_headline_content,
.bt_header_headline_Light_accent .bt_bb_background_image.btPageHeadline header h4 .bt_bb_headline_content,
.bt_header_headline_Light_accent .bt_bb_background_image.btPageHeadline header h5 .bt_bb_headline_content,
.bt_header_headline_Light_accent .bt_bb_background_image.btPageHeadline header h6 .bt_bb_headline_content,
.bt_header_headline_Light_accent .bt_bb_background_image.btPageHeadline header h7 .bt_bb_headline_content,
.bt_header_headline_Light_accent .bt_bb_background_image.btPageHeadline header h8 .bt_bb_headline_content{color: {$accentColor};}
.bt_header_headline_Dark_accent .bt_bb_background_image.btPageHeadline header h1 .bt_bb_headline_content,
.bt_header_headline_Dark_accent .bt_bb_background_image.btPageHeadline header h2 .bt_bb_headline_content,
.bt_header_headline_Dark_accent .bt_bb_background_image.btPageHeadline header h3 .bt_bb_headline_content,
.bt_header_headline_Dark_accent .bt_bb_background_image.btPageHeadline header h4 .bt_bb_headline_content,
.bt_header_headline_Dark_accent .bt_bb_background_image.btPageHeadline header h5 .bt_bb_headline_content,
.bt_header_headline_Dark_accent .bt_bb_background_image.btPageHeadline header h6 .bt_bb_headline_content,
.bt_header_headline_Dark_accent .bt_bb_background_image.btPageHeadline header h7 .bt_bb_headline_content,
.bt_header_headline_Dark_accent .bt_bb_background_image.btPageHeadline header h8 .bt_bb_headline_content{color: {$accentColor};}
.bt_header_headline_Dark_alternate .bt_bb_background_image.btPageHeadline header h1 .bt_bb_headline_content,
.bt_header_headline_Dark_alternate .bt_bb_background_image.btPageHeadline header h2 .bt_bb_headline_content,
.bt_header_headline_Dark_alternate .bt_bb_background_image.btPageHeadline header h3 .bt_bb_headline_content,
.bt_header_headline_Dark_alternate .bt_bb_background_image.btPageHeadline header h4 .bt_bb_headline_content,
.bt_header_headline_Dark_alternate .bt_bb_background_image.btPageHeadline header h5 .bt_bb_headline_content,
.bt_header_headline_Dark_alternate .bt_bb_background_image.btPageHeadline header h6 .bt_bb_headline_content,
.bt_header_headline_Dark_alternate .bt_bb_background_image.btPageHeadline header h7 .bt_bb_headline_content,
.bt_header_headline_Dark_alternate .bt_bb_background_image.btPageHeadline header h8 .bt_bb_headline_content{color: {$alternateColor};}
.btNoSearchResults .bt_bb_port #searchform input[type='submit']{
    -webkit-box-shadow: 0 0 0 3em {$accentColor} inset;
    box-shadow: 0 0 0 3em {$accentColor} inset;}
.btNoSearchResults .bt_bb_port #searchform input[type='submit']:hover{
    -webkit-box-shadow: 0 0 0 1px {$accentColor} inset;
    box-shadow: 0 0 0 1px {$accentColor} inset;
    color: {$accentColor};}
.btHasCrest.btMenuHorizontal:not(.btMenuCenter):not(.btStickyHeaderActive) .btTopToolsLeft{margin-left: {$crestWidth}px;}
.rtl.btHasCrest.btMenuHorizontal:not(.btMenuCenter):not(.btStickyHeaderActive) .btTopToolsLeft{margin-right: {$crestWidth}px;}
.btHasCrest.btMenuHorizontal:not(.btMenuCenter):not(.btStickyHeaderActive) .btBelowLogoArea .menuPort{margin-left: {$crestWidth}px;}
.btHasCrest.btMenuHorizontal:not(.btMenuCenter):not(.btStickyHeaderActive) .btCrest .btCrestImg{width: {$crestWidth}px;}
.btHasCrest.btMenuHorizontal:not(.btMenuCenter):not(.btStickyHeaderActive) .logo{padding-left: {$crestWidth}px;}
.rtl.btHasCrest.btMenuHorizontal:not(.btMenuCenter):not(.btStickyHeaderActive) .logo{padding-right: {$crestWidth}px;}
.mainHeader{
    font-family: \"{$menuFont}\";}
.mainHeader a:hover{color: {$accentColor};}
.menuPort{font-family: \"{$menuFont}\";}
.menuPort nav ul li a:hover{color: {$accentColor};}
.menuPort nav > ul > li > a{line-height: {$logoHeight}px;}
.btTextLogo{font-family: \"{$menuFont}\";
    line-height: {$logoHeight}px;}
.btLogoArea .logo img{height: {$logoHeight}px;}
.btTransparentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btAccentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btAccentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btLightDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btHasAltLogo.btStickyHeaderActive .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btTransparentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btAccentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btAccentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btLightDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btHasAltLogo.btStickyHeaderActive .btHorizontalMenuTrigger:hover .bt_bb_icon:after{border-top-color: {$accentColor};}
.btTransparentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btTransparentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btLightDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btHasAltLogo.btStickyHeaderActive .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before{border-top-color: {$accentColor};}
.btMenuHorizontal .menuPort nav > ul > li.current-menu-ancestor,
.btMenuHorizontal .menuPort nav > ul > li.current-menu-item{color: {$alternateColor};}
.btMenuHorizontal .menuPort ul ul li a:hover{color: {$accentColor};}
body.btMenuHorizontal .subToggler{
    line-height: {$logoHeight}px;}
.btMenuHorizontal .menuPort > nav > ul > li > ul li a:hover{-webkit-box-shadow: inset 5px 0 0 0 {$accentColor};
    box-shadow: inset 5px 0 0 0 {$accentColor};}
.btMenuHorizontal .topBarInMenu{
    height: {$logoHeight}px;}
.btAccentLightHeader .mainHeader,
.btAccentLightHeader .btVerticalHeaderTop{background-color: {$accentColor};}
.btAccentLightHeader .btBelowLogoArea a:hover,
.btAccentLightHeader .topBar a:hover{color: {$accentColor};}
.btAccentDarkHeader .mainHeader,
.btAccentDarkHeader .btVerticalHeaderTop{background-color: {$accentColor};}
.btAccentDarkHeader .btBelowLogoArea a:hover,
.btAccentDarkHeader .topBar a:hover{color: {$alternateColor};}
.btAccentDarkHeader.btMenuHorizontal.btMenuBelowLogo .menuPort nav > ul > li.current-menu-ancestor,
.btAccentDarkHeader.btMenuHorizontal.btMenuBelowLogo .menuPort nav > ul > li.current-menu-item{color: {$alternateColor} !important;}
.btAlternateLightHeader .mainHeader,
.btAlternateLightHeader .btVerticalHeaderTop{background-color: {$alternateColor};}
.btAlternateLightHeader .btBelowLogoArea a:hover,
.btAlternateLightHeader .topBar a:hover{color: {$accentColor};}
.btAlternateDarkHeader .mainHeader,
.btAlternateDarkHeader .btVerticalHeaderTop{background-color: {$alternateColor};}
.btAlternateDarkHeader .btBelowLogoArea a:hover,
.btAlternateDarkHeader .topBar a:hover{color: {$alternateColor};}
.btLightAccentHeader .mainHeader a:hover,
.btLightAccentHeader .btVerticalHeaderTop a:hover{color: {$accentColor};}
.btLightAccentHeader .btBelowLogoArea,
.btLightAccentHeader .topBar{background-color: {$accentColor};}
.btTransparentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btLightAccentHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btAlternateLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btAlternateDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btLightDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btHasAltLogo.btStickyHeaderActive .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btTransparentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btLightAccentHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btAlternateLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btAlternateDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btLightDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btHasAltLogo.btStickyHeaderActive .btVerticalMenuTrigger:hover .bt_bb_icon:after{border-top-color: {$accentColor};}
.btTransparentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btTransparentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btLightAccentHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAlternateLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAlternateDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btLightDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btHasAltLogo.btStickyHeaderActive .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before{border-top-color: {$accentColor};}
.btMenuVertical .mainHeader .btCloseVertical:before:hover{color: {$accentColor};}
.btMenuHorizontal .topBarInLogoArea{
    height: {$logoHeight}px;}
.btMenuHorizontal .topBarInLogoArea .topBarInLogoAreaCell{border: 0 solid {$accentColor};}
.btMenuVertical .menuPort nav:not(.rightNav):before,
.btMenuVertical .menuPort nav:not(.leftNav):after{
    background: {$accentColor};}
.btDarkSkin .btSiteFooterWidgets,
.btLightSkin .btDarkSkin .btSiteFooterWidgets,
.btDarkSkin.btLightSkin .btDarkSkin .btSiteFooterWidgets{background: {$accentColorVeryDark};}
.btDarkSkin .btSiteFooterCopyMenu .port:before,
.btLightSkin .btDarkSkin .btSiteFooterCopyMenu .port:before,
.btDarkSkin.btLightSkin .btDarkSkin .btSiteFooterCopyMenu .port:before{background-color: {$accentColor};}
.btArticleHeadline .bt_bb_headline_content a:hover{color: {$accentColor};}
.btMediaBox.btQuote:before,
.btMediaBox.btLink:before{
    background-color: {$accentColor};}
.sticky.btArticleListItem .btArticleHeadline h1 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h2 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h3 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h4 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h5 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h6 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h7 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h8 .bt_bb_headline_content span a:after{
    color: {$accentColor};}
.post-password-form p:first-child{color: {$accentColor};}
.post-password-form p:nth-child(2) input[type=\"submit\"]{
    background: {$alternateColor};}
.btPagination{font-family: \"{$headingFont}\";}
.btPagination .paging a:hover{color: {$accentColor};}
.btPagination .paging a:hover:after{border-color: {$accentColor};
    color: {$accentColor};}
.btPrevNextNav .btPrevNext .btPrevNextItem .btPrevNextTitle{font-family: \"{$headingFont}\";}
.btPrevNextNav .btPrevNext .btPrevNextItem .btPrevNextDir{
    font-family: \"{$headingSuperTitleFont}\";}
.btPrevNextNav .btPrevNext:hover .btPrevNextTitle{color: {$accentColor};}
.btArticleCategories a:hover{color: {$accentColor};}
.btArticleCategories a:not(:first-child):before{
    background-color: {$accentColor};}
.bt-comments-box .vcard .posted{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt-comments-box .commentTxt p.edit-link,
.bt-comments-box .commentTxt p.reply{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.comment-awaiting-moderation{color: {$accentColor};}
a#cancel-comment-reply-link{
    color: {$accentColor};}
a#cancel-comment-reply-link:hover{color: {$accentColor};}
.bt-comments-boxubmit{
    color: {$accentColor};
    -webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
.bt-comments-boxubmit:before{
    color: {$accentColor};}
.bt-comments-boxubmit:hover{
    -webkit-box-shadow: 0 0 0 2em {$accentColor} inset;
    box-shadow: 0 0 0 2em {$accentColor} inset;}
.btSidebar .widget_bt_bb_recent_posts ul li a:hover{color: {$accentColor} !important;}
body:not(.btNoDashInSidebar) .btBox > h4:after,
body:not(.btNoDashInSidebar) .menu-testing-menu-container > h4:after,
body:not(.btNoDashInSidebar) .btTopBox > h4:after{
    border-bottom: 3px solid {$accentColor};}
.btBox > ul li.current-menu-item > a,
.menu-testing-menu-container > ul li.current-menu-item > a,
.btTopBox > ul li.current-menu-item > a{color: {$accentColor};}
.btBox p.posted,
.btBox .quantity,
.menu-testing-menu-container p.posted,
.menu-testing-menu-container .quantity,
.btTopBox p.posted,
.btTopBox .quantity{
    font-family: \"{$bodyFont}\",Arial,Helvetica,sans-serif;}
.widget_calendar table caption{background: {$accentColor};
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.widget_rss li a.rsswidget{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.fancy-select ul.options li:hover{color: {$accentColor};}
.widget_shopping_cart .total{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.widget_shopping_cart .buttons .button{
    background: {$accentColor};}
.widget_shopping_cart .widget_shopping_cart_content .mini_cart_item .ppRemove a.remove{
    background-color: {$accentColor};}
.menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon span.cart-contents,
.topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon span.cart-contents,
.topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon span.cart-contents{
    background-color: {$accentColor};
    font: normal 10px/1 \"{$menuFont}\";}
.btMenuVertical .menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler,
.btMenuVertical .topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler,
.btMenuVertical .topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler{
    background-color: {$accentColor};}
.widget_recent_reviews{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.product_list_widget a:hover{color: {$accentColor} !important;}
.widget_price_filter .price_slider_wrapper .ui-slider .ui-slider-handle{
    background-color: {$accentColor};}
.topTools .btIconWidget:hover,
.topBarInMenu .btIconWidget:hover{color: {$accentColor};}
.btSidebar .btIconWidget:hover .btIconWidgetText,
footer .btIconWidget:hover .btIconWidgetText,
.topBarInLogoArea .btIconWidget:hover .btIconWidgetText{color: {$accentColor};}
.btAccentIconWidget.btIconWidget .btIconWidgetIcon{color: {$accentColor};}
.btLightSkin .btSiteFooterWidgets .btSearch button:hover,
.btDarkSkin .btLightSkin .btSiteFooterWidgets .btSearch button:hover,
.btLightSkin .btDarkSkin .btLightSkin .btSiteFooterWidgets .btSearch button:hover,
.btDarkSkin .btSiteFooterWidgets .btSearch button:hover,
.btLightSkin .btDarkSkin .btSiteFooterWidgets .btSearch button:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btSiteFooterWidgets .btSearch button:hover,
.btLightSkin .btSidebar .btSearch button:hover,
.btDarkSkin .btLightSkin .btSidebar .btSearch button:hover,
.btLightSkin .btDarkSkin .btLightSkin .btSidebar .btSearch button:hover,
.btDarkSkin .btSidebar .btSearch button:hover,
.btLightSkin .btDarkSkin .btSidebar .btSearch button:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btSidebar .btSearch button:hover,
.btLightSkin .btSidebar .widget_product_search button:hover,
.btDarkSkin .btLightSkin .btSidebar .widget_product_search button:hover,
.btLightSkin .btDarkSkin .btLightSkin .btSidebar .widget_product_search button:hover,
.btDarkSkin .btSidebar .widget_product_search button:hover,
.btLightSkin .btDarkSkin .btSidebar .widget_product_search button:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btSidebar .widget_product_search button:hover{background: {$accentColor} !important;
    border-color: {$accentColor} !important;}
.btSearchInner.btFromTopBox .btSearchInnerClose .bt_bb_icon a.bt_bb_icon_holder{color: {$accentColor};}
.btSearchInner.btFromTopBox .btSearchInnerClose .bt_bb_icon:hover a.bt_bb_icon_holder{color: {$accentColorDark};}
.btSearchInner.btFromTopBox button:hover:before{color: {$accentColor};}
.bt_bb_headline .bt_bb_headline_superheadline{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_headline.bt_bb_subheadline .bt_bb_headline_subheadline{font-family: \"{$headingSubTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_dash_top.bt_bb_headline .bt_bb_headline_content:before{
    color: {$accentColor};}
.bt_bb_latest_posts_item .bt_bb_latest_posts_item_image .bt_bb_latest_posts_item_date{font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_latest_posts_item .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_category .post-categories li:not(:first-child) a:before{
    background-color: {$accentColor};}
.bt_bb_latest_posts_item .bt_bb_latest_posts_item_title{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_latest_posts_item .bt_bb_latest_posts_item_title a:hover{color: {$accentColor};}
.bt_bb_post_grid_filter .bt_bb_post_grid_filter_item.active{background: {$accentColor};}
.bt_bb_service .bt_bb_service_content .bt_bb_service_content_title{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_button{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_custom_menu div ul a:hover{color: {$alternateColor};}
.wpcf7-form .wpcf7-submit{
    -webkit-box-shadow: 0 0 0 1px {$accentColor} inset;
    box-shadow: 0 0 0 1px {$accentColor} inset;
    color: {$accentColor} !important;}
.wpcf7-form .wpcf7-submit:hover{-webkit-box-shadow: 0 0 0 2em {$accentColor} inset;
    box-shadow: 0 0 0 2em {$accentColor} inset;}
.bt_bb_section[class*=\"accent_gradient\"]:before{background: -webkit-linear-gradient(top,{$accentColor} 0%,{$accentColorTransparent} 25%,{$accentColorTransparent} 75%,{$accentColor} 100%);
    background: -moz-linear-gradient(top,{$accentColor} 0%,{$accentColorTransparent} 25%,{$accentColorTransparent} 75%,{$accentColor} 100%);
    background: linear-gradient(to bottom,{$accentColor} 0%,{$accentColorTransparent} 25%,{$accentColorTransparent} 75%,{$accentColor} 100%);}
.bt_bb_section[class*=\"alternate_gradient\"]:before{background: -webkit-linear-gradient(top,{$alternateColor} 0%,{$alternateColorTransparent} 35%,{$alternateColorTransparent} 65%,{$alternateColor} 100%);
    background: -moz-linear-gradient(top,{$alternateColor} 0%,{$alternateColorTransparent} 35%,{$alternateColorTransparent} 65%,{$alternateColor} 100%);
    background: linear-gradient(to bottom,{$alternateColor} 0%,{$alternateColorTransparent} 35%,{$alternateColorTransparent} 65%,{$alternateColor} 100%);}
.accentColorLightBg{background-color: {$accentColorLight};}
.accentColorBg{background-color: {$accentColor};}
.accentColorDarkBg{background-color: {$accentColorDark};}
.accentColorVeryDarkBg{background-color: {$accentColorVeryDark};}
.accentColorVeryVeryDarkBg{background-color: {$accentColorVeryVeryDark};}
.alternateColorLightBg{background-color: {$alternateColorLight};}
.alternateColorBg{background-color: {$alternateColor};}
.alternateColorDarkBg{background-color: {$alternateColorDark};}
.alternateColorVeryDarkBg{background-color: {$alternateColorVeryDark};}
.alternateColorVeryVeryDarkBg{background-color: {$alternateColorVeryVeryDark};}
.products ul li.product .btWooShopLoopItemInner .added:after,
.products ul li.product .btWooShopLoopItemInner .loading:after,
ul.products li.product .btWooShopLoopItemInner .added:after,
ul.products li.product .btWooShopLoopItemInner .loading:after{
    background-color: {$accentColor};}
.products ul li.product .btWooShopLoopItemInner .added_to_cart,
ul.products li.product .btWooShopLoopItemInner .added_to_cart{
    color: {$accentColor};}
.products ul li.product .onsale,
ul.products li.product .onsale{
    background: {$accentColor};}
nav.woocommerce-pagination ul li a,
nav.woocommerce-pagination ul li span{
    -webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;
    color: {$accentColor};}
nav.woocommerce-pagination ul li a:focus,
nav.woocommerce-pagination ul li a:hover,
nav.woocommerce-pagination ul li a.next,
nav.woocommerce-pagination ul li a.prev,
nav.woocommerce-pagination ul li span.current{-webkit-box-shadow: 0 0 0 2em {$accentColor} inset;
    box-shadow: 0 0 0 2em {$accentColor} inset;}
div.product .onsale{
    background: {$accentColor};}
div.product div.images .woocommerce-product-gallery__trigger:after{
    -webkit-box-shadow: 0 0 0 2em {$accentColor} inset,0 0 0 2em rgba(255,255,255,.5) inset;
    box-shadow: 0 0 0 2em {$accentColor} inset,0 0 0 2em rgba(255,255,255,.5) inset;}
div.product div.images .woocommerce-product-gallery__trigger:hover:after{-webkit-box-shadow: 0 0 0 1px {$accentColor} inset,0 0 0 2em rgba(255,255,255,.5) inset;
    box-shadow: 0 0 0 1px {$accentColor} inset,0 0 0 2em rgba(255,255,255,.5) inset;
    color: {$accentColor};}
table.shop_table .coupon .input-text{
    color: {$accentColor};}
table.shop_table td.product-remove a.remove{
    color: {$accentColor};
    border: 2px solid {$accentColor};}
table.shop_table td.product-remove a.remove:hover{background-color: {$accentColor};}
ul.wc_payment_methods li .about_paypal{
    color: {$accentColor};}
.woocommerce-MyAccount-navigation ul li a{
    border-bottom: 2px solid {$accentColor};}
.woocommerce-error,
.woocommerce-info,
.woocommerce-message{
    border-top: 4px solid {$accentColor};}
.woocommerce-error{border-top-color: {$accentColor};}
.woocommerce-error a{color: {$accentColor};}
.woocommerce-info a:hover,
.woocommerce-message a:hover{
    color: {$alternateColor};}
.woocommerce-message:before,
.woocommerce-info:before{
    color: {$accentColor};}
.woocommerce .btSidebar a.button,
.woocommerce .btContent a.button,
.woocommerce-page .btSidebar a.button,
.woocommerce-page .btContent a.button,
.woocommerce .btSidebar input[type=\"submit\"],
.woocommerce .btContent input[type=\"submit\"],
.woocommerce-page .btSidebar input[type=\"submit\"],
.woocommerce-page .btContent input[type=\"submit\"],
.woocommerce .btSidebar button[type=\"submit\"],
.woocommerce .btContent button[type=\"submit\"],
.woocommerce-page .btSidebar button[type=\"submit\"],
.woocommerce-page .btContent button[type=\"submit\"],
.woocommerce .btSidebar input.button,
.woocommerce .btContent input.button,
.woocommerce-page .btSidebar input.button,
.woocommerce-page .btContent input.button,
.woocommerce .btSidebar input.alt:hover,
.woocommerce .btContent input.alt:hover,
.woocommerce-page .btSidebar input.alt:hover,
.woocommerce-page .btContent input.alt:hover,
.woocommerce .btSidebar a.button.alt:hover,
.woocommerce .btContent a.button.alt:hover,
.woocommerce-page .btSidebar a.button.alt:hover,
.woocommerce-page .btContent a.button.alt:hover,
.woocommerce .btSidebar .button.alt:hover,
.woocommerce .btContent .button.alt:hover,
.woocommerce-page .btSidebar .button.alt:hover,
.woocommerce-page .btContent .button.alt:hover,
.woocommerce .btSidebar button.alt:hover,
.woocommerce .btContent button.alt:hover,
.woocommerce-page .btSidebar button.alt:hover,
.woocommerce-page .btContent button.alt:hover,
div.woocommerce a.button,
div.woocommerce input[type=\"submit\"],
div.woocommerce button[type=\"submit\"],
div.woocommerce input.button,
div.woocommerce input.alt:hover,
div.woocommerce a.button.alt:hover,
div.woocommerce .button.alt:hover,
div.woocommerce button.alt:hover{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;
    color: {$accentColor};}
.woocommerce .btSidebar a.button:hover,
.woocommerce .btContent a.button:hover,
.woocommerce-page .btSidebar a.button:hover,
.woocommerce-page .btContent a.button:hover,
.woocommerce .btSidebar input[type=\"submit\"]:hover,
.woocommerce .btContent input[type=\"submit\"]:hover,
.woocommerce-page .btSidebar input[type=\"submit\"]:hover,
.woocommerce-page .btContent input[type=\"submit\"]:hover,
.woocommerce .btSidebar button[type=\"submit\"]:hover,
.woocommerce .btContent button[type=\"submit\"]:hover,
.woocommerce-page .btSidebar button[type=\"submit\"]:hover,
.woocommerce-page .btContent button[type=\"submit\"]:hover,
.woocommerce .btSidebar input.button:hover,
.woocommerce .btContent input.button:hover,
.woocommerce-page .btSidebar input.button:hover,
.woocommerce-page .btContent input.button:hover,
.woocommerce .btSidebar input.alt,
.woocommerce .btContent input.alt,
.woocommerce-page .btSidebar input.alt,
.woocommerce-page .btContent input.alt,
.woocommerce .btSidebar a.button.alt,
.woocommerce .btContent a.button.alt,
.woocommerce-page .btSidebar a.button.alt,
.woocommerce-page .btContent a.button.alt,
.woocommerce .btSidebar .button.alt,
.woocommerce .btContent .button.alt,
.woocommerce-page .btSidebar .button.alt,
.woocommerce-page .btContent .button.alt,
.woocommerce .btSidebar button.alt,
.woocommerce .btContent button.alt,
.woocommerce-page .btSidebar button.alt,
.woocommerce-page .btContent button.alt,
div.woocommerce a.button:hover,
div.woocommerce input[type=\"submit\"]:hover,
div.woocommerce button[type=\"submit\"]:hover,
div.woocommerce input.button:hover,
div.woocommerce input.alt,
div.woocommerce a.button.alt,
div.woocommerce .button.alt,
div.woocommerce button.alt{-webkit-box-shadow: 0 0 0 2em {$accentColor} inset;
    box-shadow: 0 0 0 2em {$accentColor} inset;}
.star-rating span:before{
    color: {$accentColor};}
p.stars a[class^=\"star-\"].active:after,
p.stars a[class^=\"star-\"]:hover:after{color: {$accentColor};}
.select2-container--default .select2-results__option--highlighted[aria-selected],
.select2-container--default .select2-results__option--highlighted[data-selected]{background-color: {$accentColor};}
.btQuoteBooking .btContactNext{border-color: {$accentColor};
    color: {$accentColor};}
.btQuoteBooking .btQuoteSwitch.on .btQuoteSwitchInner{background: {$accentColor};}
.btQuoteBooking textarea:focus,
.btQuoteBooking input[type=\"text\"]:focus,
.btQuoteBooking input[type=\"email\"]:focus,
.btQuoteBooking input[type=\"password\"]:focus,
.btQuoteBooking .fancy-select .trigger:focus,
.btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btQuoteBooking .ddcommon.borderRadiusBtm .ddTitleText:focus{-webkit-box-shadow: 0 0 4px 0 {$accentColor};
    box-shadow: 0 0 4px 0 {$accentColor};}
.btLightSkin .btQuoteBooking textarea:focus,
.btDarkSkin .btLightSkin .btQuoteBooking textarea:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking textarea:focus,
.btLightSkin .btQuoteBooking input[type=\"text\"]:focus,
.btDarkSkin .btLightSkin .btQuoteBooking input[type=\"text\"]:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking input[type=\"text\"]:focus,
.btLightSkin .btQuoteBooking input[type=\"email\"]:focus,
.btDarkSkin .btLightSkin .btQuoteBooking input[type=\"email\"]:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking input[type=\"email\"]:focus,
.btLightSkin .btQuoteBooking input[type=\"password\"]:focus,
.btDarkSkin .btLightSkin .btQuoteBooking input[type=\"password\"]:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking input[type=\"password\"]:focus,
.btLightSkin .btQuoteBooking .fancy-select .trigger:focus,
.btDarkSkin .btLightSkin .btQuoteBooking .fancy-select .trigger:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking .fancy-select .trigger:focus,
.btLightSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btDarkSkin .btLightSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btLightSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btDarkSkin .btLightSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btLightSkin .btQuoteBooking .ddcommon.borderRadiusBtm .ddTitleText:focus,
.btDarkSkin .btLightSkin .btQuoteBooking .ddcommon.borderRadiusBtm .ddTitleText:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking .ddcommon.borderRadiusBtm .ddTitleText:focus{-webkit-box-shadow: 0 0 4px 0 {$accentColor};
    box-shadow: 0 0 4px 0 {$accentColor};}
.btDarkSkin .btQuoteBooking textarea:focus,
.btLightSkin .btDarkSkin .btQuoteBooking textarea:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking textarea:focus,
.btDarkSkin .btQuoteBooking input[type=\"text\"]:focus,
.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"text\"]:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"text\"]:focus,
.btDarkSkin .btQuoteBooking input[type=\"email\"]:focus,
.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"email\"]:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"email\"]:focus,
.btDarkSkin .btQuoteBooking input[type=\"password\"]:focus,
.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"password\"]:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"password\"]:focus,
.btDarkSkin .btQuoteBooking .fancy-select .trigger:focus,
.btLightSkin .btDarkSkin .btQuoteBooking .fancy-select .trigger:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking .fancy-select .trigger:focus,
.btDarkSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btLightSkin .btDarkSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btDarkSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btLightSkin .btDarkSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btDarkSkin .btQuoteBooking .ddcommon.borderRadiusBtm .ddTitleText:focus,
.btLightSkin .btDarkSkin .btQuoteBooking .ddcommon.borderRadiusBtm .ddTitleText:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking .ddcommon.borderRadiusBtm .ddTitleText:focus{-webkit-box-shadow: 0 0 4px 0 {$accentColor};
    box-shadow: 0 0 4px 0 {$accentColor};}
.btQuoteBooking .dd.ddcommon.borderRadiusTp .ddTitleText,
.btQuoteBooking .dd.ddcommon.borderRadiusBtm .ddTitleText{-webkit-box-shadow: 5px 0 0 {$accentColor} inset,0 2px 10px rgba(0,0,0,.2);
    box-shadow: 5px 0 0 {$accentColor} inset,0 2px 10px rgba(0,0,0,.2);}
.btQuoteBooking .ui-slider .ui-slider-handle{background: {$accentColor};}
.btQuoteBooking .btQuoteBookingForm .btQuoteTotal{
    background: {$accentColor};}
.btQuoteBooking .btContactFieldMandatory.btContactFieldError input,
.btQuoteBooking .btContactFieldMandatory.btContactFieldError textarea{-webkit-box-shadow: 0 0 0 1px {$accentColor} inset;
    box-shadow: 0 0 0 1px {$accentColor} inset;
    border-color: {$accentColor};}
.btQuoteBooking .btContactFieldMandatory.btContactFieldError .dd.ddcommon.borderRadius .ddTitleText{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
.btQuoteBooking .btSubmitMessage{color: {$accentColor};}
.btQuoteBooking .dd.ddcommon.borderRadiusTp .ddTitleText,
.btQuoteBooking .dd.ddcommon.borderRadiusBtm .ddTitleText{-webkit-box-shadow: 0 0 4px 0 {$accentColor};
    box-shadow: 0 0 4px 0 {$accentColor};}
.btQuoteBooking .btContactSubmit{
    background-color: {$accentColor};}
.btDatePicker .ui-datepicker-header{background-color: {$accentColor};}
.bt_bb_timetable .bt_bb_timetable_title_flex{
    background-color: {$accentColor};
    font-family: \"{$headingFont}\";}
.bt_bb_timetable .bt_bb_timetable_title_flex .bt_bb_timetable_title{
    font-family: \"{$headingFont}\";}
.bt_bb_timetable .bt_bb_timetable_inner_row.btToday .bt_bb_timetable_day span:not(.bt_bb_timetable_inner_desc):before{
    color: {$alternateColor};}
.bt_bb_scheduled_game .bt_bb_scheduled_game_headline .bt_bb_scheduled_game_supertitle{font-family: \"{$headingSuperTitleFont}\";}
.bt_bb_scheduled_game .bt_bb_scheduled_game_headline .bt_bb_scheduled_game_title{font-family: \"{$headingFont}\";
    color: {$accentColor};}
.bt_bb_scheduled_game .bt_bb_scheduled_game_headline .bt_bb_scheduled_game_subtitle{font-family: \"{$headingSuperTitleFont}\";}
.bt_bb_scheduled_game.btWithLink .bt_bb_scheduled_game_url:hover .bt_bb_scheduled_game_title{color: {$alternateColor};}
.bt_bb_game_result .bt_bb_game_result_supertitle{font-family: \"{$headingSuperTitleFont}\";}
.bt_bb_game_result .bt_bb_game_result_wrap .bt_bb_game_result_team .bt_bb_game_result_data .bt_bb_game_result_value{
    font-family: \"{$headingFont}\";}
.bt_bb_game_result .bt_bb_game_result_wrap .bt_bb_game_result_team .bt_bb_game_result_data .bt_bb_game_result_title{font-family: \"{$headingSuperTitleFont}\";}
table.bt_bb_table tr.bt_bb_table_row{
    font-family: \"{$headingFont}\";}
table.bt_bb_table tr.bt_bb_table_row:first-child{background-color: {$accentColor};}
.btSubscribeFormRow .btSubscribeFormInput input{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.btSubscribeFormRow .btSubscribeFormButton input{
    -webkit-box-shadow: 0 0 0 2em {$accentColor} inset;
    box-shadow: 0 0 0 2em {$accentColor} inset;}
.btSubscribeFormRow .btSubscribeFormButton input:hover{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset !important;
    box-shadow: 0 0 0 2px {$accentColor} inset !important;
    color: {$accentColor} !important;}
", array() );