<?php

class bt_bb_scheduled_game extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'image'        		=> '',
			'title'        		=> '',
			'supertitle'     	=> '',
			'subtitle'     		=> '',
			'url'        		=> '',
			'target'       		=> '',
			'color_scheme'  	=> ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $el_style .= '; --schedule-game-primary-color:' . $color_scheme_colors[0] . '; --schedule-game-secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;

		if ( $url != '' ) {
			$class[] = 'btWithLink';
		}

		if ( $url != '' && $url != '#' && substr( $url, 0, 4 ) != 'http' && substr( $url, 0, 5 ) != 'https' && substr( $url, 0, 6 ) != 'mailto' ) {
			$link = bt_bb_get_permalink_by_slug( $url );
		} else {
			$link = $url;
		}

		if ( $image != '' && is_numeric( $image ) ) {
			$post_image = get_post( $image );
			$alt = isset($post_image) ? get_post_meta($post_image->ID, '_wp_attachment_image_alt', true) : '';
			if ( $post_image == '' ) return;
		
			$image = wp_get_attachment_image_src( $image, "full");
			$image = $image[0];
			if ( $alt == '' ) {
				$alt = $title;
			}
		}
		
		
		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		$output = '';
		
		// IMAGE
		if ( $image != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_image' ) . '">' . '<img src="' . esc_url_raw( $image ) . '" alt="' . esc_attr( $alt ) . '">' . '</div>';
		
		// HEADLINE
		$output .= '<div class="' . esc_attr( $this->shortcode . '_headline' ) . '">';

			if ( $supertitle != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_supertitle' ) . '">' . $supertitle . '</div>';

			if ( $link != '' ) {
				$output .= '<a href="' . esc_url_raw( $link ) . '" target="' . esc_attr( $target ) . '" class="' . esc_attr( $this->shortcode . '_url' ) . '">';
					if ( $title != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_title' ) . '">' . $title . '</div>';
				$output .= '</a>';
			} else {
				$output .= '<div class="' . esc_attr( $this->shortcode . '_url' ) . '">';
					if ( $title != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_title' ) . '">' . $title . '</div>';
				$output .= '</div>';
			}
			
			if ( $subtitle != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_subtitle' ) . '">' . $subtitle . '</div>';
		
		$output .= '</div>';

		
		$output = '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . '>' . $output . '</div>';

		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;
	}

	function map_shortcode() {

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Scheduled game', 'oxigeno' ), 'description' => esc_html__( 'Scheduled game with image', 'oxigeno' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'image', 'type' => 'attach_image', 'heading' => esc_html__( 'Image', 'oxigeno' ), 'preview' => true ),
				array( 'param_name' => 'supertitle', 'type' => 'textfield', 'heading' => esc_html__( 'Supertitle', 'oxigeno' ) ),
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => esc_html__( 'Title', 'oxigeno' ), 'preview' => true ),
				array( 'param_name' => 'subtitle', 'type' => 'textfield', 'heading' => esc_html__( 'Subtitle', 'oxigeno' ) ),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'oxigeno' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'oxigeno' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'oxigeno' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'oxigeno' ) => '_blank',
					)),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'oxigeno' ), 'value' => $color_scheme_arr, 'preview' => true ),
			)
		) );
	}
}